﻿using System;

namespace Formatting
{
    class Program
    {
        static void Main(string[] args)
        {
            {
                // Listing 10-5. Konwersja liczb na łańcuchy znaków przy użyciu metody ToString.
                int myValue = 45;
                string myString = myValue.ToString();
                Console.WriteLine(myString);
            }

            {
                // Listing 10-6. Wywołanie ToString na rzecz danej typu decimal.
                decimal myValue = 45.65M;
                string myString = myValue.ToString();
                Console.WriteLine(myString);
            }

            {
                // Listing 10-7. Formatowanie wartości walutowych.
                decimal dollarAmount = 123165.4539M;
                string text = dollarAmount.ToString("C");
                Console.WriteLine(text);
            }

            {
                // Listing 10-8. Określanie liczby miejsc dziesiętnych w formacie walutowym.
                decimal dollarAmount = 123165.4539M;
                string text = dollarAmount.ToString("C3");
                Console.WriteLine(text);
            }

            {
                // Listing 10-9. Format dziesiętny z określoneą precyzją.
                int amount = 1654539;
                string text = amount.ToString("D9");
                Console.WriteLine(text);
            }

            {
                // Listing 10-10. Format dziesiętny o nieokreślonej długości.
                int amount = -2895729;
                string text = amount.ToString("D");
                Console.WriteLine(text);
            }

            {
                // Listing 10-11. Format szesnastkowy.
                int amount = 256;
                string text = amount.ToString("X");
                Console.WriteLine(text);
            }

            {
                // Listing 10-12. Format szesnastkowy z określoną precyzją.
                int amount = 256;
                string text = amount.ToString("X4");
                Console.WriteLine(text);
            }
             
            {
                // Listing 10-13. Format wykładniczy.
                double amount = 254.23875839484;
                string text = amount.ToString("E4");
                Console.WriteLine(text);
            }

            {
                // Listing 10-14. Format wykładniczy bez określonej precyzji.
                double amount = 254.23875839484;
                string text = amount.ToString("E");
                Console.WriteLine(text);
            }

            {
                // Listing 10-15. Format stałoprzecinkowy.
                double amount = 152.68385485;
                string text = amount.ToString("F4");
                Console.WriteLine(text);
            }

            {
                // Listing 10-16. Format stałoprzecinkowy wymuszający dodanie zer na końcu liczby.
                double amount = 152.68;
                string text = amount.ToString("F4");
                Console.WriteLine(text);
            }

            {
                // Listing 10-17. Format ogólny
                double amount = 152.68;
                string text = amount.ToString("G4");
                Console.WriteLine(text);

                double amount2 = 0.00000000000015268;
                text = amount2.ToString("G4");
                Console.WriteLine(text);
            }

            {
                // Listing 10-18. Format liczbowy.
                double amount = 1520494.684848;
                string text = amount.ToString("N4");
                Console.WriteLine(text);
            }

            {
                // Listing 10-19.Format procentowy.
                double amount = 0.684848;
                string text = amount.ToString("P4");
                Console.WriteLine(text);
            }

            {
                // Listing 10-20. Format powrotny
                double amount = 0.684848;
                string text = amount.ToString("R");
                Console.WriteLine(text);
            }

            {
                // Listing 10-21. Niestandardowe formaty liczbowe.
                double value = 12.3456;
                Console.WriteLine(value.ToString("00.######"));

                value = 1.23456;
                Console.WriteLine(value.ToString("00.000000"));

                Console.WriteLine(value.ToString("##.000000"));
            }

            {
                string text;

                // Listing 10-22. Miejsca na cyfry po przecinku dziesiętnym.
                double value = 1234.5678;
                text = value.ToString("#.###");
                Console.WriteLine(text);
            }

            {
                // Listing 10-23. Wyświetlanie cyfry 0 na początku i końcu liczby.
                double value = 0.46;
                string text = value.ToString("#.###");
                Console.WriteLine(text);
            }

            {
                // Listing 10-24. Zastosowanie przecinka do grupowania liczb.
                int value = 12345678;
                string text = value.ToString("#,#");
                Console.WriteLine(text);
            }

            {
                // Listing 10-25. Zastosowanie przecinka do skalowania liczby w dół.
                int value = 12345678;
                string text = value.ToString("#,#,,.");
                Console.WriteLine(text);
            }

            {
                // Listing 10-26. Domyślna kropka dziesiętna.
                int value = 12345678;
                string text = value.ToString("#,#,,");
                Console.WriteLine(text);
            }

            {
                // Listing 10-27. Dowolny tekst w niestandardowym łańcuchu formatującym.
                int value = 12345678;
                string text = value.ToString("###-### oraz ###");
                Console.WriteLine(text);
            }

            {
                // Listing 10-28. Oznaczanie znaków specjalnych w łańcuchach formatujących.
                int value = 12345678;
                string text = value.ToString("###-### \\# ###");
                Console.WriteLine(text);
            }

            {
                // Listing 10-29. Poprzedzanie łańcucha formatującego prefiksem @.
                int value = 12345678;
                string text = value.ToString(@"###-### \# ###");
                Console.WriteLine(text);
            }

            {
                // Listing 10-30. Literał łańcuchowy umieszczony wewnątrz łańcucha formatującego.
                int value = 12345678;
                string text = value.ToString(@"###-### \# ### 'jest liczbą'");
                Console.WriteLine(text);
            }

            {
                // Listing 10-31. Zastosowanie znaku procenta w niestandardowym łańcuchu formatującym.
                double value = 0.95;
                string text = value.ToString("#0.##%");
                Console.WriteLine(text);
            }

            {
                // Listing 10-32. Przygotowania do wyświetlenia wartości typu DatTimeOffset.
                DateTimeOffset tmo = GetTimeFromSomewhere();
                DateTime localDateTime = tmo.ToLocalTime().DateTime;
                Console.WriteLine(localDateTime);
            }

            {
                // Listing 10-33. Prezentacja dat w różnych formatach.
                DateTime time = new DateTime(2001, 12, 24, 13, 14, 15, 16);
                Console.WriteLine(time.ToString("d"));
                Console.WriteLine(time.ToShortDateString());
                Console.WriteLine(time.ToString("D"));
                Console.WriteLine(time.ToLongDateString());
            }

            {
                // Listing 10-34. Pobieranie samych informacji o czasie.
                DateTime time = new DateTime(2001, 12, 24, 13, 14, 15, 16);
                Console.WriteLine(time.ToString("t"));
                Console.WriteLine(time.ToShortTimeString());
                Console.WriteLine(time.ToString("T"));
                Console.WriteLine(time.ToLongTimeString());
            }

            {
                // Listing 10-35. Prezentowanie informacji o dacie i godzinie.
                DateTime time = new DateTime(2001, 12, 24, 13, 14, 15, 16);
                Console.WriteLine(time.ToString("g"));
                Console.WriteLine(time.ToString("G"));
                Console.WriteLine(time.ToString("f"));
                Console.WriteLine(time.ToString("F"));
            }

            {
                // Listing 10-36. Format powrotny dla typu DateTime.
                DateTime time = new DateTime(2001, 12, 24, 13, 14, 15, 16);
                Console.WriteLine(time.ToString("O"));
            }

            {
                // Listing 10-37. Format uniwersalny zapewniający możliwość sortowania.
                DateTime time = new DateTime(2001, 12, 24, 13, 14, 15, 16);
                Console.WriteLine(time.ToString("u"));
            }

            {
                // Listing 10-38. Formatowanie dnia.
                DateTime time = new DateTime(2001, 12, 24, 13, 14, 15, 16);
                Console.WriteLine(time.ToString("dddd"));
                Console.WriteLine(time.ToString("ddd"));
                Console.WriteLine(time.ToString("dd"));
            }

            {
                // Listing 10-39. Konwersja łańcucha znaków na liczbę całkowitą.
                int converted = Convert.ToInt32("35");
                Console.WriteLine(converted);
            }

            {
                // Listing 10-40. Konwersja łańcucha reprezentującego wartość szesnastkową na liczbę.
                int converted = Convert.ToInt32("35", 16);
                Console.WriteLine(converted);
                converted = Convert.ToInt32("0xFF", 16);
                Console.WriteLine(converted);
            }

            {
                try
                {
                    // Listing 10-41. Próba konwersji fragmentu tekstu na liczbę.
                    double converted = Convert.ToDouble("Cóż, a jak myślisz?");
                }
                catch (FormatException)
                {
                    Console.WriteLine("Nie udało się skonwertować łańcucha.");
                }
            }

            {
                // Listing 10-42. Unikanie obsługi wyjątków dzięki zastosowaniu metody TryParse.
                int parsed;
                if (!int.TryParse("Cóż, a jak myślisz?", out parsed))
                {
                    Console.WriteLine("Ta konwersja się nie uda!");
                }
            }

            {
                // Listing 10-43. Metoda DateTime.ParseExact
                DateTime dt =
                    DateTime.ParseExact("12^04^2008", "dd^MM^yyyy", System.Globalization.CultureInfo.CurrentCulture);
                Console.WriteLine(dt);
            }
        }

        private static DateTimeOffset GetTimeFromSomewhere()
        {
            return DateTimeOffset.UtcNow;
        }
    }
}
